' Test program for WII Classic Controller
' Requires CMMD Firmware Rev5.05.05 or higher
' William M Leue 9/3/2020

option default integer
option base 1

const NUM_BUTTONS = 15

' Graphic constants
const CWIDTH = 600
const CHEIGHT = 280
const DHEIGHT = 75

const JSRAD = 30
const JSTRAD = 15
const JSXOFF = 100
const JDPLEN = 10
const SBRAD = 8
const SBXOFF = 30
const MBRAD = 16
const MBXSEP = 120
const MBYSEP = 40
const DPADW = MBRAD+2
const DPADL = JSRAD+4
const DPADX = 200
const RLBX = JSXOFF+40
const RLBW = JSRAD+30
const RLBH = DPADW+10
const ZRLBW = RLBW
const ZRLBH = RLBH+8

' Left and Right Joystick calibration
' These seem weird, likely because mine is a used controller
' Probably these should be the same left and right. Also,
' the maximum and minimum values are not very stable and seem
' to change each time you move the joysticks.
' Regardless, the graphic feedback seems ok.
const LJSNX = 128
const LJSNY = 120
const LJSXMAX = 232
const LJSXMIN = 24
const LJSYMAX = 228
const LJSYMIN = 16
const RJSNX = 120
const RJSNY = 136
const RJSXMAX = 232
const RJSXMIN = 16
const RJSYMAX = 240
const RJSYMIN = 24

' Globals
dim bnames$(NUM_BUTTONS)
dim bspots(NUM_BUTTONS, 2)

dim lx = 0
dim prev_lx = 0
dim ly = 0
dim prev_ly = 0
dim rx = 0
dim prev_rx = 0
dim ry = 0
dim prev_ry = 0
dim l = 0
dim prev_l = 0
dim r = 0
dim prev_r = 0
dim lxoff = 0 : dim lyoff = 0
dim rxoff = 0 : dim ryoff = 0
dim float plx, ply, prx, pry

' Main Program
readButtonNames
wii classic open 3, wiicbintr
DrawController

' loop to read WII Classic controller parameters until
' terminated by any keypress
x$ = INKEY$

do
 
  lx = classic(LX, 3)
  ly = classic(LY, 3)
  rx = classic(RX, 3)
  ry = classic(RY, 3)
  l = classic(L, 3)
  r = classic(R, 3)
  b = classic(B, 3)
   
  lxoff = 0 : lyoff = 0
  rxoff = 0 : ryoff = 0
  ljactive = 0 : rjactive = 0
  if lx <> prev_lx or ly <> prev_ly then
    ljactive = 1
    plx = (1.0*(lx-LJSNX))/(LJSXMAX-LJSNX)
    if lx < LJSNX then plx = -plx
    ply = (1.0*(ly-LJSNY))/(LJSYMAX-LJSNY)
    if ly < LJSNY then ply = -ply
    if lx > LJSNX then lxoff = JDPLEN*plx
    if lx < LJSNX then lxoff = -JDPLEN*plx
    if ly > LJSNY then lyoff = -JDPLEN*ply
    if ly < LJSNY then lyoff = JDPLEN*ply
    prev_lx = lx : prev_ly = ly
  end if
  if rx <> prev_rx or ry <> prev_ry then
    rjactive = 1
    prx = (1.0*(rx-RJSNX))/(RJSXMAX-RJSNX)
    if rx < RJSNX then prx = -prx
    pry = (1.0*(ry-RJSNY))/(RJSYMAX-RJSNY)
    if ry < RJSNY then pry = -pry
    if rx > RJSNX then rxoff = JDPLEN*prx
    if rx < RJSNX then rxoff = -JDPLEN*prx
    if ry > RJSNY then ryoff = -JDPLEN*pry
    if ry < RJSNY then ryoff = JDPLEN*pry
    prev_rx = rx : prev_ry = ry
  end if
  if ljactive or rjactive then DrawController
  if l <> prev_l then
    prev_l = l
  end if
  if r <> prev_r then
    prev_r = r
  end if

loop until INKEY$ <> ""

wii classic close
end

' wii classic button ISR
sub wiicbintr
  local bmask, test, bx, by

  b = classic(B, 3)
  for i = 0 to 14
    bmask = 2^i
    test = b and bmask
    if test <> 0 then
      bx = bspots(i+1, 1) : by = bspots(i+1, 2)
      circle bx, by, SBRAD, 1, 1, RGB(RED), RGB(RED)
      pause 100
      DrawController
    end if
  next i        
end sub

' read text button names
sub ReadButtonNames
  local i
  for i = 1 to NUM_BUTTONS
    read bnames$(i)
  next i
end sub

' Draw a crude graphical rendering of the controller
sub DrawController
  local x, y, cx, cy, sx, sy, t, jc
  local xv(13), yv(13)

  page write 1
  cls
  t = classic(T, 3)
  text MM.HRES\2, 15, "WII Classic Controller ID: " + str$(t), "CB"
  text MM.HRES\2, 30, "Press any keyboard key to quit", "CB"

  ' crude controller outline
  x = MM.HRES\2 - CWIDTH\2
  y = MM.VRES\2 - (CHEIGHT+DHEIGHT)\2 + 50
  rbox x, y-DHEIGHT, CWIDTH, CHEIGHT, 100, RGB(WHITE), RGB(BLACK)
  rbox x, y, CWIDTH, CHEIGHT, 100, RGB(WHITE), RGB(BLACK)
  cx = x + CWIDTH\2
  cy = y + CHEIGHT\2

  ' joysticks
  sx = cx - JSXOFF
  sy = y + CHEIGHT-JSRAD-15
  circle sx, sy, JSRAD
  ljc = RGB(BLACK)
  if lxoff <> 0 or lyoff <> 0 then ljc = RGB(YELLOW)
  circle sx+lxoff, sy+lyoff, JSTRAD,,,, ljc
  'lxoff = 0 : lyoff = 0
  sx = cx + JSXOFF
  circle sx, sy, JSRAD
  rjc = RGB(BLACK)
  if rrxoff <> 0 or ryoff <> 0 then rjc = RGB(YELLOW)
  circle sx+rxoff, sy+ryoff, JSTRAD,,,, rjc
  'rxoff = 0 : ryoff = 0

  ' central small buttons
  sx = cx - SBXOFF
  sy = cy
  circle sx, sy, SBRAD
  text sx, sy-15, "Select", "CB", 7
  bspots(4, 1) = sx : bspots(4, 2) = sy
  sx = cx
  circle sx, sy, SBRAD,,,, RGB(BLUE)
  text sx, sy+25, "Home", "CB", 7
  bspots(3, 1) = sx : bspots(3, 2) = sy
  sx = cx + SBXOFF
  circle sx, sy, SBRAD
  text sx, sy-15, "Start", "CB", 7
  bspots(2, 1) = sx : bspots(2, 2) = sy

  ' right side 4-button group
  sx = x + CWIDTH-35
  sy = cy
  circle sx, sy, MBRAD
  text sx, sy, "a", "CM",4
  bspots(12, 1) = sx : bspots(12, 2) = sy
  sx = sx - MBXSEP
  circle sx, sy, MBRAD
  text sx, sy, "y", "CM",4
  bspots(13, 1) = sx : bspots(13, 2) = sy
  sx = sx + MBXSEP\2
  sy = cy - MBYSEP
  circle sx, sy, MBRAD
  text sx, sy, "x", "CM",4
  bspots(11, 1) = sx : bspots(11, 2) = sy
  sy = cy + MBYSEP
  circle sx, sy, MBRAD
  text sx, sy, "b", "CM",4
  bspots(14, 1) = sx : bspots(14, 2) = sy

  ' D-Pad
  xv(1) = cx - DPADX-DPADL\2 : yv(1) = cy - DPADW\2
  xv(2) = xv(1) + DPADL      : yv(2) = yv(1)
  xv(3) = xv(2)              : yv(3) = yv(2) - DPADL
  xv(4) = xv(3) + DPADW      : yv(4) = yv(3)
  xv(5) = xv(4)              : yv(5) = yv(4) + DPADL
  xv(6) = xv(5) + DPADL      : yv(6) = yv(5)
  xv(7) = xv(6)              : yv(7) = yv(6) + DPADW
  xv(8) = xv(7) - DPADL      : yv(8) = yv(7)
  xv(9) = xv(8)              : yv(9) = yv(8) + DPADL
  xv(10) = xv(9) - DPADW     : yv(10) = yv(9)
  xv(11) = xv(10)            : yv(11) = yv(10) - DPADL
  xv(12) = xv(11) - DPADL    : yv(12) = yv(11)
  xv(13) = xv(1)             : yv(13) = yv(1)
  polygon 13, xv(), yv()
  bspots(6, 1) = cx-DPADX+26 : bspots(6, 2) = cy+DPADL-5
  bspots(7, 1) = cx-DPADX+DPADL+DPADW+6 : bspots(7, 2) = cy
  bspots(8, 1) = cx-DPADX+26 : bspots(8, 2) = cy-DPADL+5
  bspots(9, 1) = cx-DPADX-DPADL-DPADW+46 : bspots(9, 2) = cy
  
  ' L&R, ZL and ZR buttons
  sx = cx - RLBX
  sy = y - DHEIGHT+40
  rbox sx, sy, RLBW, RLBH, 10
  text sx+RLBW\2, sy+RLBH\2, "L", "CM",4  
  bspots(5, 1) = sx+RLBW\2   : bspots(5, 2) = sy+RLBH\2
  rbox sx, sy-38, ZRLBW, ZRLBH, 10
  text sx+RLBW\2, sy-38+ZRLBH\2, "ZL", "CM",4  
  bspots(15, 1) = sx+ZRLBH\2 : bspots(15, 2) = sy-38+ZRLBH\2
  sx = cx + RLBX  
  rbox sx, sy, RLBW, RLBH, 10
  text sx+RLBW\2, sy+RLBH\2, "R", "CM",4  
  bspots(1, 1) = sx+RLBW\2   : bspots(1, 2) = sy+RLBH\2
  rbox sx, sy-38, ZRLBW, ZRLBH, 10
  text sx+RLBW\2, sy-38+ZRLBH\2, "ZR", "CM",4  
  bspots(10, 1) = sx+ZRLBW\2 : bspots(10, 2) = sy-38+ZRLBH\2

  page write 0
  blit 0, 0, 0, 0, MM.HRES, MM.VRES, 1
end sub  

data "R", "start", "home", "select", "L", "down", "right", "up"
data "left", "ZR", "x", "a", "y", "b", "ZL" 
